CONTAINER Ohiphandle
{
	NAME Ohiphandle;
	INCLUDE Obase;

	GROUP BASIC_SETTINGS_GROUP
	{
        LONG MODE
        {
            ANIM OFF;
            CYCLE
            {
                MODE_SETUP;
                MODE_SETUP_SYMMETRY;
                MODE_WALK;
            }
        }

        GROUP PARENTS_DIALOG_GROUP
        {
            DEFAULT 1;

            LONG RIG_PRESET_MENUE
            {
                ANIM OFF;
                CYCLE
                {
                    STANDARD_MOCAP_RIG;
                    PIM_V1_RIG;
                    AUTODESK_RIG_LOW;
                    AUTODESK_RIG_HIGH;
                    AXYZ_RIG;
                    POSER_RIG_V;
                    POSER_RIG_M;
                    DAZ_RIG_2;
                    DAZ_RIG;
                    RENDERPEOPLE;
                    FUSE_MIXAMO;
                    NEW_RIG;
                }
            }

            GROUP
            {
                COLUMNS 2;
                BUTTON BUTTON_LOAD_RIG {}
                BOOL SYNC_JOINTS {ANIM OFF;}
                BUTTON SAVE_RELATIVE_MATRIX {}
                BUTTON DELETE_RELATIVE_MATRIX {}
                BUTTON CREATE_IK_CONSTRAINTS {}
            }

            LINK HIPHANDLE_NULL {ANIM OFF;}
            LINK HIPHANDLE_PARENT {ANIM OFF;}
            VECTOR UEBER_MAT_OFFSET {ANIM OFF; UNIT METER;}
            LINK FIRST_SPINE_PARENT {ANIM OFF;}
            LINK LAST_SPINE_PARENT {ANIM OFF;}
            LINK LAST_CHEST_PARENT {ANIM OFF;}
            LINK FIRST_NECK_PARENT {ANIM OFF;}
            LINK HEAD_PARENT {ANIM OFF;}
            LINK HEAD_END_PARENT {ANIM OFF;}

            LINK LEFT_THIGH_PARENT {ANIM OFF;}
            LINK LEFT_KNEE_PARENT {ANIM OFF;}
            LINK LEFT_ANKLE_PARENT {ANIM OFF;}
            LINK LEFT_TOES_PARENT {ANIM OFF;}
            LINK LEFT_TOES_TIP_PARENT {ANIM OFF;}

            LINK RIGHT_THIGH_PARENT {ANIM OFF;}
            LINK RIGHT_KNEE_PARENT {ANIM OFF;}
            LINK RIGHT_ANKLE_PARENT {ANIM OFF;}
            LINK RIGHT_TOES_PARENT {ANIM OFF;}
            LINK RIGHT_TOES_TIP_PARENT {ANIM OFF;}

            LINK LEFT_COLLAR_PARENT {ANIM OFF;}
            LINK LEFT_SHOULDER_PARENT {ANIM OFF;}
            LINK LEFT_FOREARM_PARENT {ANIM OFF;}
            LINK LEFT_FOREARM_TWIST_PARENT {ANIM OFF;}
            LINK LEFT_HAND_PARENT {ANIM OFF;}
            LINK LEFT_HAND_TIP_PARENT {ANIM OFF;}
            LINK L_FINGER_K_PARENT {ANIM OFF;}
            LINK L_FINGER_R_PARENT {ANIM OFF;}
            LINK L_FINGER_M_PARENT {ANIM OFF;}
            LINK L_FINGER_Z_PARENT {ANIM OFF;}
            LINK L_FINGER_D_PARENT {ANIM OFF;}

            LINK RIGHT_COLLAR_PARENT {ANIM OFF;}
            LINK RIGHT_SHOULDER_PARENT {ANIM OFF;}
            LINK RIGHT_FOREARM_PARENT {ANIM OFF;}
            LINK RIGHT_FOREARM_TWIST_PARENT {ANIM OFF;}
            LINK RIGHT_HAND_PARENT {ANIM OFF;}
            LINK RIGHT_HAND_TIP_PARENT {ANIM OFF;}
            LINK R_FINGER_K_PARENT {ANIM OFF;}
            LINK R_FINGER_R_PARENT {ANIM OFF;}
            LINK R_FINGER_M_PARENT {ANIM OFF;}
            LINK R_FINGER_Z_PARENT {ANIM OFF;}
            LINK R_FINGER_D_PARENT {ANIM OFF;}
        }
    }

    GROUP MOTION_DESIGNER_GROUP
    {
        GROUP
        {
            COLUMNS 2;

            BUTTON EXPORT_WALKDESIGNER {}
            BUTTON IMPORT_WALKDESIGNER {}
        }
        BOOL WALK_IN_PLACE {}
        REAL TIME_OFFSET {UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER;}
        REAL SPEED_MORPH {UNIT PERCENT; MIN 0.0; MAX 200.0; CUSTOMGUI REALSLIDER;}
        REAL DYNAMIC_MORPH {UNIT PERCENT; MIN 0.0; MAX 200.0; CUSTOMGUI REALSLIDER;}
        REAL STAIR_CLIMBING_MORPH {UNIT PERCENT; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER;}
        REAL STUFENHOEHE {UNIT METER; MIN 0.0; MAX 40.0; CUSTOMGUI REALSLIDER;}
        REAL STUFENTIEFE {UNIT METER; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER;}

        SEPARATOR {LINE;}

        REAL SLIDER_ARM_TIME_OFFSET {UNIT PERCENT; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER;}
        REAL AMPLITUDE_ELLBOW_SWING {MIN 0.0; MAX 8.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_CHEST_POS_X {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_CHEST_ROT_X {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_CHEST_ROT_Y {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        SEPARATOR {LINE;}
        REAL SLIDER_HIP_TIME_OFFSET {UNIT PERCENT; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_HIP_POS_X {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_HIP_POS_Y {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_HIP_POS_Z {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_HIP_ROT_X {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_HIP_ROT_Y {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_HIP_ROT_Z {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        SEPARATOR {LINE;}
        REAL SLIDER_FOOT_POS_X {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_FOOT_POS_Y {MINSLIDER 0.0; MAXSLIDER 40.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_FOOT_POS_Z {MINSLIDER 0.0; MAXSLIDER 120.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_FOOT_ROT_X {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_FOOT_ROT_Y {MINSLIDER 0.0; MAXSLIDER 50.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
    }

    GROUP STATIC_POSES_GROUP
    {
        REAL SIT_DOWN_SLIDER {UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        VECTOR SIT_POSITION {UNIT METER;}
        VECTOR SIT_WRIST_DELTA_POS {UNIT METER;}
        VECTOR SIT_WRIST_DELTA_DIR {UNIT METER;}
        VECTOR SIT_ELLBOW_DELTA_POS {UNIT METER;}
        VECTOR SIT_ELLBOW_DELTA_DIR {UNIT METER;}

        SEPARATOR {LINE;}

        REAL R_STATIC_ARM_MORPH {UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER;}
        REAL R_STATIC_HAND_POSITION {UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}
        REAL R_STATIC_CASE_MORPH {UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER;}
        VECTOR R_STATIC_HANDRAIL_POS {MIN -50.0; MAX 50.0; STEP 0.1;}
        VECTOR R_STATIC_CASE_POS {MIN -50.0; MAX 50.0; STEP 0.1;}

        SEPARATOR {LINE;}

        REAL L_STATIC_ARM_MORPH {UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER;}
        REAL L_STATIC_HAND_POSITION {UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; CUSTOMGUI REALSLIDER;}
        REAL L_STATIC_CASE_MORPH {UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER;}
        VECTOR L_STATIC_HANDRAIL_POS {MIN -50.0; MAX 50.0; STEP 0.1;}

        SEPARATOR {HIDDEN; LINE;}

        VECTOR STILL_SHOULDER_POS {HIDDEN; UNIT METER;}
        VECTOR L_STATIC_SHOULDER {HIDDEN; UNIT METER;}
        VECTOR R_STATIC_SHOULDER {HIDDEN; UNIT METER;}
        VECTOR STILL_ELLBOW_POS {HIDDEN; UNIT METER;}
        VECTOR STILL_ELLBOW_TARGET_POS {HIDDEN; UNIT METER;}
        VECTOR STILL_WRIST_POS {HIDDEN; UNIT METER;}
        VECTOR STILL_WRIST_TARGET_POS {HIDDEN; UNIT METER;}
        VECTOR STILL_HAND_TARGET_POS {HIDDEN; UNIT METER;}

        SEPARATOR {LINE;}

        VECTOR DELTA_HIP {}
        VECTOR DELTA_HIP_ROT {}
        VECTOR SPINE_Z_POS_CORRECTION {}
        VECTOR DELTA_CHEST_POS {}
        VECTOR DELTA_CHEST_ROT {}
        VECTOR HEAD_TARGET_POINT {}
        REAL SLIDER_HEAD_TO_NECK {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_HEAD_TO_CHEST {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        VECTOR DELTA_SHOULDER_POS {}
        VECTOR DELTA_ELLBOW_POS {}
        VECTOR DELTA_ELLBOW_TARGET_POS {}
        VECTOR DELTA_WRIST_POS {}
        VECTOR DELTA_WRIST_TARGET_POS {}
        VECTOR DELTA_HAND_TARGET_POS {}
        VECTOR FEET_OFFSET_STATIC {UNIT METER;}
        VECTOR FEET_OFFSET_WALK {UNIT METER;}
        BOOL MIRRORED_FEET_OFFSET {}
        REAL SLIDER_FOOT_DIR {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_TOE_ORIENTATION {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}
        REAL SLIDER_TIP_TOE {MINSLIDER -20.0; MAXSLIDER 20.0; STEP 0.1; CUSTOMGUI REALSLIDER;}

        GROUP
        {
            COLUMNS 2;
            BUTTON EXPORT_SETUPWERTE {}
            BUTTON IMPORT_SETUPWERTE {}
        }
    }

    GROUP IK_CONSTRAINTS_GROUP
    {
        REAL GLOBAL_IK_STRENGTH {UNIT PERCENT; MIN 0.0; MAX 100.0; CUSTOMGUI REALSLIDER;}
        LINK IK_HIP_ANFASSER_LINK {ANIM OFF;}
        LINK IK_CHEST_ANFASSER_LINK {ANIM OFF;}
        LINK IK_HEAD_LINK {ANIM OFF;}
        LINK IK_LEFT_ELLBOW_LINK {ANIM OFF;}
        LINK IK_LEFT_HAND_LINK {ANIM OFF;}
        LINK IK_RIGHT_ELLBOW_LINK {ANIM OFF;}
        LINK IK_RIGHT_HAND_LINK {ANIM OFF;}
        LINK IK_LEFT_KNEE_LINK {ANIM OFF;}
        LINK IK_LEFT_FOOT_LINK {ANIM OFF;}
        LINK IK_RIGHT_KNEE_LINK {ANIM OFF;}
        LINK IK_RIGHT_FOOT_LINK {ANIM OFF;}
    }

    GROUP HANDLES_DIALOG_GROUP
    {
        VECTOR HIP_POS {HIDDEN;UNIT METER;}
        VECTOR X_AXIS_SYMMETRY {HIDDEN;UNIT METER;}
        VECTOR FRONTAL_HIP_TARGET {HIDDEN;UNIT METER;}
        VECTOR FIRST_SPINE_JOINT {HIDDEN;UNIT METER;}
        VECTOR LAST_SPINE_JOINT {HIDDEN;UNIT METER;}
        VECTOR LAST_CHEST_JOINT {HIDDEN;UNIT METER;}
        VECTOR SIDE_CHEST_TARGET {HIDDEN;UNIT METER;}
        VECTOR FRONTAL_CHEST_TARGET {HIDDEN;UNIT METER;}
        VECTOR FIRST_NECK_JOINT {HIDDEN;UNIT METER;}
        VECTOR HEAD_JOINT {HIDDEN;UNIT METER;}
        VECTOR HEAD_DIRECTION {HIDDEN;UNIT METER;}
        VECTOR HEAD_END_JOINT {HIDDEN;UNIT METER;}

        VECTOR LEFT_HIP_JOINT {HIDDEN; ANIM OFF; UNIT METER;}
        VECTOR LEFT_KNEE_TARGET {HIDDEN; ANIM OFF; UNIT METER;}
        VECTOR LEFT_KNEE_DIRECTION {HIDDEN; ANIM OFF; UNIT METER;}
        VECTOR LEFT_FOOT {HIDDEN;UNIT METER;}
        VECTOR LEFT_FOOT_DIRECTION {HIDDEN;UNIT METER;}
        VECTOR LEFT_ANKLE {HIDDEN;UNIT METER;}
        VECTOR LEFT_FOOT_ROLL {HIDDEN;UNIT METER;}
        VECTOR LEFT_TOES {HIDDEN;ANIM OFF; UNIT METER;}
        VECTOR LEFT_TOES_TIP {HIDDEN;ANIM OFF; UNIT METER;}
        VECTOR LEFT_FOOT_O_BANK {HIDDEN;ANIM OFF; UNIT METER;}
        VECTOR LEFT_FOOT_I_BANK {HIDDEN;ANIM OFF; UNIT METER;}
        VECTOR LEFT_FOOT_BANKING {HIDDEN;UNIT METER;}

        VECTOR RIGHT_KNEE_TARGET {HIDDEN; ANIM OFF; UNIT METER;}
        VECTOR RIGHT_KNEE_DIRECTION {HIDDEN; ANIM OFF; UNIT METER;}
        VECTOR RIGHT_FOOT {HIDDEN;UNIT METER;}
        VECTOR RIGHT_FOOT_DIRECTION {HIDDEN;UNIT METER;}
        VECTOR RIGHT_ANKLE {HIDDEN;UNIT METER;}
        VECTOR RIGHT_FOOT_ROLL {HIDDEN;UNIT METER;}
        VECTOR RIGHT_TOES {HIDDEN;ANIM OFF; UNIT METER;}
        VECTOR RIGHT_TOES_TIP {HIDDEN;ANIM OFF; UNIT METER;}
        VECTOR RIGHT_FOOT_O_BANK {HIDDEN;ANIM OFF; UNIT METER;}
        VECTOR RIGHT_FOOT_I_BANK {HIDDEN;ANIM OFF; UNIT METER;}
        VECTOR RIGHT_FOOT_BANKING {HIDDEN;UNIT METER;}

        VECTOR LEFT_COLLAR_POS {HIDDEN;UNIT METER;}
        VECTOR LEFT_SHOULDER_JOINT {HIDDEN;UNIT METER;}
        VECTOR LEFT_ELLBOW_DIRECTION {HIDDEN;UNIT METER;}
        VECTOR LEFT_ELLBOW_TARGET {HIDDEN;UNIT METER;}
        VECTOR LEFT_FOREARM_DIRECTION {HIDDEN;UNIT METER;}
        VECTOR LEFT_HAND_JOINT {HIDDEN;UNIT METER;}
        VECTOR LEFT_HAND_DIRECTION {HIDDEN;UNIT METER;}

        VECTOR RIGHT_COLLAR_POS {HIDDEN;UNIT METER;}
        VECTOR RIGHT_SHOULDER_JOINT {HIDDEN;UNIT METER;}
        VECTOR RIGHT_ELLBOW_DIRECTION {HIDDEN;UNIT METER;}
        VECTOR RIGHT_ELLBOW_TARGET {HIDDEN;UNIT METER;}
        VECTOR RIGHT_FOREARM_DIRECTION {HIDDEN;UNIT METER;}
        VECTOR RIGHT_HAND_JOINT {HIDDEN;UNIT METER;}
        VECTOR RIGHT_HAND_DIRECTION {HIDDEN;UNIT METER;}

        VECTOR R_STATIC_SHOULDER {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_CASE {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_TARGET_CASE {UNIT METER;}
        VECTOR R_STATIC_WRIST_CASE {UNIT METER;}
        VECTOR R_STATIC_WRIST_TARGET_CASE {UNIT METER;}
        VECTOR R_STATIC_HAND_TARGET_CASE {UNIT METER;}

        VECTOR R_STATIC_ELLBOW_CASE_B {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_TARGET_CASE_B {UNIT METER;}
        VECTOR R_STATIC_WRIST_CASE_B {UNIT METER;}
        VECTOR R_STATIC_WRIST_TARGET_CASE_B {UNIT METER;}
        VECTOR R_STATIC_HAND_TARGET_CASE_B {UNIT METER;}

        VECTOR R_STATIC_ELLBOW_HANDRAIL {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_TARGET_HANDRAIL {UNIT METER;}
        VECTOR R_STATIC_WRIST_HANDRAIL {UNIT METER;}
        VECTOR R_STATIC_WRIST_TARGET_HANDRAIL {UNIT METER;}
        VECTOR R_STATIC_HAND_TARGET_HANDRAIL {UNIT METER;}

        VECTOR R_STATIC_ELLBOW_READ {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_TARGET_READ {UNIT METER;}
        VECTOR R_STATIC_WRIST_READ {UNIT METER;}
        VECTOR R_STATIC_WRIST_TARGET_READ {UNIT METER;}
        VECTOR R_STATIC_HAND_TARGET_READ {UNIT METER;}

        VECTOR R_STATIC_ELLBOW_POINT {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_TARGET_POINT {UNIT METER;}
        VECTOR R_STATIC_WRIST_POINT {UNIT METER;}
        VECTOR R_STATIC_WRIST_TARGET_POINT {UNIT METER;}
        VECTOR R_STATIC_HAND_TARGET_POINT {UNIT METER;}

        VECTOR R_STATIC_ELLBOW_PHONE {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_TARGET_PHONE {UNIT METER;}
        VECTOR R_STATIC_WRIST_PHONE {UNIT METER;}
        VECTOR R_STATIC_WRIST_TARGET_PHONE {UNIT METER;}
        VECTOR R_STATIC_HAND_TARGET_PHONE {UNIT METER;}

        VECTOR R_STATIC_ELLBOW_CASE2 {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_TARGET_CASE2 {UNIT METER;}
        VECTOR R_STATIC_WRIST_CASE2 {UNIT METER;}
        VECTOR R_STATIC_WRIST_TARGET_CASE2 {UNIT METER;}
        VECTOR R_STATIC_HAND_TARGET_CASE2 {UNIT METER;}

        VECTOR R_STATIC_ELLBOW_CASE_B2 {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_TARGET_CASE_B2 {UNIT METER;}
        VECTOR R_STATIC_WRIST_CASE_B2 {UNIT METER;}
        VECTOR R_STATIC_WRIST_TARGET_CASE_B2 {UNIT METER;}
        VECTOR R_STATIC_HAND_TARGET_CASE_B2 {UNIT METER;}

        VECTOR R_STATIC_ELLBOW_HANDRAIL2 {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_TARGET_HANDRAIL2 {UNIT METER;}
        VECTOR R_STATIC_WRIST_HANDRAIL2 {UNIT METER;}
        VECTOR R_STATIC_WRIST_TARGET_HANDRAIL2 {UNIT METER;}
        VECTOR R_STATIC_HAND_TARGET_HANDRAIL2 {UNIT METER;}

        VECTOR R_STATIC_ELLBOW_PHONE2 {UNIT METER;}
        VECTOR R_STATIC_ELLBOW_TARGET_PHONE2 {UNIT METER;}
        VECTOR R_STATIC_WRIST_PHONE2 {UNIT METER;}
        VECTOR R_STATIC_WRIST_TARGET_PHONE2 {UNIT METER;}
        VECTOR R_STATIC_HAND_TARGET_PHONE2 {UNIT METER;}
    }

    GROUP CURVES_GROUP
    {
        HIDDEN;
        SPLINE WALK_SLOW_HIP_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_HIP_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_HIP_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_HIP_ROT_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_HIP_ROT_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -3; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_HIP_ROT_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE WALK_FAST_HIP_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_HIP_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_HIP_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_HIP_ROT_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_HIP_ROT_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -3; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_HIP_ROT_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -3; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE WALK_SLOW_FOOT_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_FOOT_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_FOOT_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_FOOT_DIR_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_FOOT_DIR_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -3; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE WALK_FAST_FOOT_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_FOOT_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -3; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_FOOT_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_FOOT_DIR_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_FOOT_DIR_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -3; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_UP_FOOT_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -3; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_UP_FOOT_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -2; Y_MAX 2; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_UP_HIP_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_DOWN_FOOT_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -3; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_DOWN_FOOT_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -2; Y_MAX 2; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_DOWN_HIP_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_UP_HIP_DIR_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_TOES_POS_Y
            {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN 0; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
            }
        SPLINE WALK_FAST_TOES_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN 0; Y_MAX 20; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_UP_TOES_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN 0; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_DOWN_TOES_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN 0; Y_MAX 3; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE WALK_SLOW_CHEST_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE WALK_SLOW_CHEST_ROT_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_CHEST_ROT_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE WALK_FAST_CHEST_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE WALK_FAST_CHEST_ROT_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -30; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_CHEST_ROT_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE STAIR_UP_CHEST_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_UP_CHEST_ROT_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_UP_CHEST_ROT_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE STAIR_DOWN_CHEST_ROT_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE STAIR_DOWN_CHEST_ROT_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE STAIR_UP_SPINE_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -5; Y_MAX 5; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE WALK_SLOW_ELLBOW_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -20; Y_MAX 20; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_ELLBOW_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -20; Y_MAX 20; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_ELLBOW_DIRECTION_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -20; Y_MAX 200; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_ELLBOW_DIRECTION_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -20; Y_MAX 200; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE WALK_SLOW_WRIST_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -20; Y_MAX 20; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_WRIST_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 30; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_SLOW_WRIST_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -50; Y_MAX 50; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_WRIST_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 30; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_WRIST_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -50; Y_MAX 50; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE WALK_SLOW_SHOULDER_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_SHOULDER_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE SIT_HIP_CURVE_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN 0; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE SIT_HIP_CURVE_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN 0; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE SIT_HIP_CURVE_DIR_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE SIT_CHEST_CURVE_DIR_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE SIT_ELLBOW_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE SIT_ELLBOW_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -50; Y_MAX 50; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE SIT_ELLBOW_DIR_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE SIT_ELLBOW_DIR_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE SIT_ELLBOW_DIR_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE SIT_WRIST_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE SIT_WRIST_POS_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1.0; Y_MAX 20; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE SIT_WRIST_POS_Z
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -20; Y_MAX 1; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE SIT_WRIST_DIR_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -50; Y_MAX 50; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE SIT_WRIST_DIR_Y
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -50; Y_MAX 50; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE IDLE_HIP_POS_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE IDLE_CHEST_DIR_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE IDLE_HEAD_DIR_X
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -10; Y_MAX 10; X_STEPS 0.01; Y_STEPS 0.01;
        }

        SPLINE SIT_HAND_DIR
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1.57; Y_MAX 1.57; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE WALK_FAST_HAND_DIR
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN -1.57; Y_MAX 1.57; X_STEPS 0.01; Y_STEPS 0.01;
        }
        SPLINE VORSCHUB_KURVE
        {
            SHOWGRID_H;
            SHOWGRID_V;
            GRIDSIZE_H 5;
            GRIDSIZE_V 5;
            MINSIZE_H 120;
            MINSIZE_V 90;
            EDIT_H;
            EDIT_V;
            LABELS_H;
            LABELS_V;
            HAS_ROUND_SLIDER;
            X_MIN 0; X_MAX 1; Y_MIN 0.0; Y_MAX 5.0; X_STEPS 0.01; Y_STEPS 0.01;
        }
	}
}
